#include <stdio.h>
#include <stdlib.h>

int compare(const void *a, const void *b) {
    return (*(int *)a - *(int *)b);
}

int main() {
    int numRows, numCols, subRows, subCols;
    scanf("%d %d %d %d", &numRows, &numCols, &subRows, &subCols);
    int *arrayA = (int *)malloc(numRows * numCols * sizeof(int));
    for (int i = 0; i < numRows * numCols; i++) {
        scanf("%d", &arrayA[i]);
    }
    int **matrixA = (int **)malloc(numRows * sizeof(int *));
    for (int i = 0; i < numRows; i++) {
        matrixA[i] = (int *)malloc(numCols * sizeof(int));
        for (int j = 0; j < numCols; j++) {
            matrixA[i][j] = arrayA[i * numCols + j];
        }
    }
    int maxVal = INT_MIN;
    int maxRowIdx = 0;
    int maxColIdx = 0;
    for (int i = 0; i < numRows; i++) {
        for (int j = 0; j < numCols; j++) {
            if (matrixA[i][j] > maxVal) {
                maxVal = matrixA[i][j];
                maxRowIdx = i;
                maxColIdx = j;
            }
        }
    }
    int tmp = matrixA[numRows / 2][numCols / 2];
    matrixA[numRows / 2][numCols / 2] = maxVal;
    matrixA[maxRowIdx][maxColIdx] = tmp;
    int **sortedMatrix = (int **)malloc(numRows * sizeof(int *));
    for (int i = 0; i < numRows; i++) {
        sortedMatrix[i] = (int *)malloc(numCols * sizeof(int));
        qsort(matrixA[i], numCols, sizeof(int), compare);
        int idx = numCols / 2;
        for (int j = 0; j < numCols; j++) {
            sortedMatrix[i][j] = matrixA[i][(j + idx) % numCols];
        }
    }
    int ***submatrices = (int ***)malloc((numRows - subRows + 1) * sizeof(int **));
    for (int i = 0; i < numRows - subRows + 1; i++) {
        submatrices[i] = (int **)malloc((numCols - subCols + 1) * sizeof(int *));
        for (int j = 0; j < numCols - subCols + 1; j++) {
            submatrices[i][j] = (int *)malloc(subRows * subCols * sizeof(int));
            for (int k = 0; k < subRows; k++) {
                for (int l = 0; l < subCols; l++) {
                    submatrices[i][j][k * subCols + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }
    int totalSum = 0;
    for (int i = 0; i < numRows - subRows + 1; i++) {
        for (int j = 0; j < numCols - subCols + 1; j++) {
            for (int k = 0; k < subRows * subCols; k++) {
                totalSum += submatrices[i][j][k];
            }
        }
    }
    printf("%d\n", totalSum);
    for (int i = 0; i < numRows; i++) {
        free(matrixA[i]);
        free(sortedMatrix[i]);
    }
    free(matrixA);
    free(sortedMatrix);
    for (int i = 0; i < numRows - subRows + 1; i++) {
        for (int j = 0; j < numCols - subCols + 1; j++) {
            free(submatrices[i][j]);
        }
        free(submatrices[i]);
    }
    free(submatrices);
    free(arrayA);
    return 0;
}